<?php 
dike_lc('lcweb', PCMA_DIKE_SLUG, true);

include_once(PC_DIR . '/classes/simple_form_validator.php');
include_once(PC_DIR . '/settings/settings_engine.php');
 
include_once(PCMA_DIR . '/settings/custom_fields.php');
include_once(PCMA_DIR . '/settings/structure.php');

$ml_key = PCMA_ML;
$engine = new pc_settings_engine('pcma_settings', $GLOBALS['pcma_settings_tabs'], $GLOBALS['pcma_settings_structure']);


// encrypt password
if(isset($_POST['pcma_smtp_psw']) && $_POST['pcma_smtp_psw'] != '|||lcwp_sf_psw_placeh|||') {	
    $_POST['pcma_smtp_psw'] = base64_encode($_POST['pcma_smtp_psw']);
}
?>

<div class="wrap lcwp_settings_wrap">
    <div class="lcwp_settings_head">
        <h2 class="lcwp_settings_page_title"><?php esc_html_e('PrivateContent - Mail Actions', $ml_key) ?></h2>  
        
        <div class="lcwp_settings_head_cmds">
            <?php echo $engine->import_export_btns() ?>
            <form class="lcwp_sf_search_wrap">
                <i class="dashicons dashicons-no-alt"></i>
                <input type="text" name="lcwp_sf_search" value="" placeholder="<?php esc_attr_e('search fields', $ml_key) ?> .." /> 
            </form>
        </div>
    </div>
    
	<?php
    // get fetched data and allow customizations
    if($engine->form_submitted()) {
       
	    $fdata = $engine->form_data;
        $errors = (!empty($engine->errors)) ? $engine->errors : array();
        

		//////////


		// custom validation for users verification
		if($fdata['pcma_mv_enable']) {
			if(strpos($fdata['pcma_mv_txt'], '%VER-URL%') === false) { 
				 $errors[ esc_html__('E-mail verification', PCMA_ML) ] = __('"%VER-URL%" variable is not present in the e-mail text', PCMA_ML); 
			}
			if(empty($fdata['pcma_mv_subj']) || empty($fdata['pcma_mv_txt'])) {
				$errors[ esc_html__('E-mail verification', PCMA_ML) ] = __("E-mail builder's fields must be filled to enable it", PCMA_ML); 	
			}
		}
		
		
		// custom validation for SMTP
		if($fdata['pcma_use_smtp']) {
			if(empty($fdata['pcma_smtp_host']) || empty($fdata['pcma_smtp_user']) || empty($fdata['pcma_smtp_psw'])) {
				$errors['SMTP'] = __('All fields must be filled to enable it', PCMA_ML); 	
			}
		}
		
		
		// custom validation for new user notification
		if($fdata['pcma_nnu_enable']) {
			if(trim($fdata['pcma_nnu_mail_multi'][0]) == '' || trim($fdata['pcma_nnu_subj']) == '' || trim($fdata['pcma_nnu_txt']) == '') {
				$errors[ esc_html__('Admin notifier', PCMA_ML) ] = __('All fields must be filled to enable it', PCMA_ML); 	
			}
		}
		if($fdata['pcma_dun_enable']) {
			if(trim($fdata['pcma_nnu_mail_multi'][0]) == '' || trim($fdata['pcma_dun_subj']) == '' || trim($fdata['pcma_dun_txt']) == '') {
				$errors[ esc_html__('Admin notifier', PCMA_ML) ] = __('All fields must be filled to enable it', PCMA_ML); 	
			}
		}
		
		
		// custom validation for activated users by admins
		if($fdata['pcma_nau_enable']) {
			if(empty($fdata['pcma_nau_subj']) || empty($fdata['pcma_nau_txt'])) {
				$errors[ esc_html__('User notifier', PCMA_ML) ] = __('All fields must be filled to enable it', PCMA_ML); 	
			}
		}
		
		
		// custom validation for imported users
		if($fdata['pcma_wm_enable']) {
			if(empty($fdata['pcma_wm_subj']) || empty($fdata['pcma_wm_txt'])) {
				$errors[ esc_html__('Welcome message', PCMA_ML) ] = __('All fields must be filled to enable it', PCMA_ML); 	
			}
		}
		
		
		// custom validation for imported users
		if($fdata['pcma_niu_enable']) {
			if(empty($fdata['pcma_niu_subj']) || empty($fdata['pcma_niu_txt'])) {
				$errors[ esc_html__('Imported users notifier', PCMA_ML) ] = __('All fields must be filled to enable it', PCMA_ML); 	
			}
		}
		
		
		// custom validation for psw recovery
		if($fdata['pcma_psw_recovery']) { 
			if(strpos($fdata['pcma_psw_mail_txt'], '%PSW%') === false) { 
				$errors[ esc_html__('Password recovery', PCMA_ML)] = __('The "%PSW%" variable is not present in the e-mail text', PCMA_ML); 
			}
			if(empty($fdata['pcma_psw_mail_subj']) || empty($fdata['pcma_psw_mail_txt'])) {
				$errors[ esc_html__('Password recovery', PCMA_ML) ] = __('All fields must be filled to enable it', PCMA_ML); 
			}
		}
		
		
		// password recovery also with e-mail - check database on first activation
		if($fdata['pcma_pr_with_email'] && !get_option('pcma_pr_with_email')) { 
			global $pc_users;
			
			$checked = array();
			$users = $pc_users->get_users(array('to_get' => array('email'), 'limit' => -1));
			
			foreach($users as $user) {
				if(empty($user['email'])) {
					$errors[ esc_html__('Password Recovery with e-mail', PCMA_ML) ] = __("One or more users don't have an e-mail", PCMA_ML); 
					break;	
				}
				
				if(in_array($user['email'], $checked)) {
					$errors[ esc_html__('Password Recovery with e-mail', PCMA_ML) ] = __("One or more users have the same e-mail", PCMA_ML); 	
					break;
				}
				
				$checked[] = $user['email'];	
			}
		}
		

		//////////


        // PCMA-FILTER - manipulate setting errors - passes errors array and form values - error subject as index + error text as val
        $errors = apply_filters('pcma_setting_errors', $errors, $fdata);	
        
        
        // save or print error
        if(empty($errors)) {
            
			// if e-mail verification is enabled, force registration user status to be pending
			if($fdata['pcma_mv_enable']) {
				update_option('pg_registered_pending', 1);	
			}
			
			// mailchimp sync - no list selected - erase categories sync
			if(!$fdata['pcma_mc_list']) {
				delete_option('pcma_interests');	
			}
			
			// admin notifier - split e-mails
			if(!empty($fdata['pcma_nnu_mail_multi_field'])) {
				$fdata['pcma_nnu_mail_multi_field'] = explode(',', $fdata['pcma_nnu_mail_multi_field']);	
			}
			
			// password recovery also with e-mail - force pvtContent settings
			if($fdata['pcma_pr_with_email']) {
				delete_option('pg_allow_duplicated_mails');
			}
			
			//////////
			
			
			// PCMA-FILTER - allow data manipulation (or custom actions) before settings save - passes form values
            $engine->form_data = apply_filters('pcma_before_save_settings', $fdata); 
			
            // save
            $engine->save_data();
            $engine->successful_save_redirect();
        }
        
        // compose and return errors
        else {
            echo $engine->get_error_message_html($errors);
        }
    }
	
	
	// if successfully saved
	echo $engine->get_success_message_html();
	
	// print form code
    echo $engine->get_code();
    ?>
</div>





<?php // TEMPLATES - LIGHTBOX CONTENTS ?>
<div id="pcma_mt_builder_lb_code" class="pc_displaynone">
	<div class="pcma_mt_builder_wrap">
        <div class="pc_spinner pc_spinner_big"></div>
        
    	<form>
        	<input type="button" name="pcma_mtb_code_view" 	value="<?php esc_attr_e('Code view', PCMA_ML) ?>" class="button-secondary pcma_mtb_sel_btn" />
            <input type="button" name="pcma_mtb_preview" 	value="<?php esc_attr_e('Preview', PCMA_ML) ?>" class="button-secondary" />
            
            <input type="text" name="pcma_mtb_title" value="" placeholder="Template title" autocomplete="off" maxlength="250" />
            <input type="hidden" name="pcma_mail_template_id" value="" autocomplete="off" />
            
            <input type="button" name="pcma_mtb_save" value="<?php esc_attr_e('Save', PCMA_ML) ?>" class="button-primary" />
            
            <div class="pcma_mtb_helper pcma_mtb_helper_shown">
            	<i class="dashicons dashicons-info" aria-hidden="true" title="<?php esc_attr_e('toggle helper', PCMA_ML) ?>"></i>
  				<div class="pcma_mtb_helper_txt">
                	<p><strong>Insert valid HTML containing the <strong>%CONTENT%</strong> placeholder. It will be replaced with e-mail contents.</strong></p>
					<p>E-mail code rules: must contain inline CSS, images must be included with absolute URL.</p>
                    
					<p>Extra placeholders: 
                    	<ul>
                        	<li>%SITE-TITLE%</li>
                            <li>%YEAR% - <em><?php _e("Current year", PCMA_ML) ?></em></li>
                            <li>%NAME% - <em><?php _e("User's Name", PCMA_ML) ?></em></li>
                        	<li>%SURNAME%</li>
							<li>%USERNAME%</li>
							<li>%MAIL%</li>
                            <li>%PC-CAT%</li>
                        </ul>
					</p>
                    <p>Remember you can use <a href="http://www.lcweb.it/privatecontent/user-data-add-on" target="_blank">User Data add-on</a> shortcode to insert custom fields into the mail text</p>
            	</div>
			</div>
        </form>
        
        <div class="pcma_mt_builder_code_wrap">
        	<textarea name="pcma_mtb_editor" class="lcwp_sf_code_editor pcma_mt_builder_editor" data-language="htmlmixed" autocomplete="off"></textarea>
        </div>
        <iframe href="" data-baseurl="<?php echo PCMA_URL ?>/mail_template_preview.php" class="pcma_mt_builder_preview_wrap pc_displaynone" /></iframe>
	</div>
</div>





<?php // SCRIPTS ?>
<script type="text/javascript">
(function($) { 
    "use strict";     
    
    const settings_baseurl = `<?php echo $engine->baseurl ?>`;
    
    $(document).ready(function() {	
        var nonce			= "<?php echo wp_create_nonce('lcwp_ajax') ?>",
            mv_is_acting 	= false,
            mailc_is_acting = false;


        
        // unwrap unwanted warnings in lcwp_settings_head
        setTimeout(function() {
            $('.lcwp_settings_head > *').not('.lcwp_settings_page_title, .lcwp_settings_head_cmds').each(function() {
                $('.lcwp_settings_wrap').prepend( $(this).detach() ); 
            });
        }, 200);
        
        
        // (re)load e-mail templates
        var pcma_load_mail_templates = function() {
            var $wrap = $('.pc_pcma_mail_templates > td');
            $wrap.html('<div class="pc_spinner"></div>');

            var data = {
                action	: 'pcma_settings_get_mail_templates',
                nonce	: nonce
            };
            $.post(ajaxurl, data, function(response) {
                response = JSON.parse(response);

                var list_code	= '',
                    dd_code		= '';

                $.each(response, function(id, name) {

                    if(parseInt(id, 10)) {
                        list_code += 
                        '<tr data-template-id="'+ id +'">'+
                            '<td><span class="dashicons dashicons-no-alt" title="<?php esc_attr_e('delete template', PCMA_ML) ?>"></span></td>'+
                            '<td><span class="dashicons dashicons-edit" title="<?php esc_attr_e('edit template', PCMA_ML) ?>"></span></td>'+
                            '<td>'+ name +'</th>'+
                        '</tr>';
                    }

                    dd_code += 
                    '<option value="'+ id +'">'+ name +'</option>';
                });


                // override list
                list_code = (list_code) ? '<table class="pcma_mail_templates_list">'+ list_code +'</table>' : '<p><em class="pcma_mail_templates_notemp"><?php esc_attr_e('No templates created yet', PCMA_ML) ?></em></p>';
                $wrap.html(list_code);


                // override dropdowns
                var targeted_dd = ['pcma_test_mail_template', 'pcma_mv_template', 'pcma_nnu_template', 'pcma_dun_template', 'pcma_nau_template', 'pcma_wm_template', 'pcma_niu_template', 'pcma_psw_mail_template'];

                $.each(targeted_dd, function(i, dd_name) { 
                    var $dd = $('select[name='+ dd_name +']'),
                        selected = $dd.val();

                    $dd.html(dd_code);
                    $dd.find('option[value="'+ selected +'"]').prop('selected', 'selected');

                    const resyncEvent = new Event('lc-select-refresh');
                    $dd[0].dispatchEvent(resyncEvent);
                });


                // hook for other add-ons
                $(window).trigger('pcma_refresh_mail_templates_dd', [dd_code]);
            })
            .fail(function(e) {
                if(e.status) {
                    console.error(e);
                    lc_wp_popup_message('error', "<?php esc_html_e('Error performing the action', PCMA_ML) ?>");
                }
            });

        };
        pcma_load_mail_templates();



        // add new template - trigger lightbox
        var pcma_open_mail_template_lb = function(template_to_load) {
            $.magnificPopup.open({
                items : {
                    src: '#pcma_mt_builder_lb_code > *',
                    type: 'inline'
                },
                mainClass	: 'pcma_mt_builder',
                closeOnContentClick	: false,
                closeOnBgClick		: false, 
                preloader	: false,
                callbacks	: {
                    beforeOpen: function() {
                        if($(window).width() < 800) {
                          this.st.focus = false;
                        }
                    },
                    open : function() {

                        // codemirror
                        if(!$('.pcma_mt_builder .CodeMirror').length) {
                            window.pcma_mt_builder = CodeMirror.fromTextArea( $('.pcma_mt_builder .lcwp_sf_code_editor')[0], {
                                lineNumbers	: true,
                                mode		: $('.pcma_mt_builder .lcwp_sf_code_editor').data('language'),
                                lineWrapping: true,
                            });
                        }
                        else {
                            // go immediately to code view
                            $('.pcma_mt_builder input[name="pcma_mtb_code_view"]').trigger('click'); 
                        }


                        // load template data
                        if(template_to_load) {
                            var $wrap = $('.pcma_mt_builder .pcma_mt_builder_wrap');
                            $wrap.addClass('pcma_mtb_loading');

                            // save contents into a transient
                            var data = {
                                action		: 'pcma_get_template_data',
                                template_id	: template_to_load,
                                nonce		: nonce,
                            };
                            var ajax = $.post(ajaxurl, data, function(response) {
                                var resp = JSON.parse(response);

                                if(resp.status == 'success') {
                                    $('.pcma_mt_builder input[name="pcma_mtb_title"]').val(resp.title);
                                    $('.pcma_mt_builder input[name="pcma_mail_template_id"]').val(template_to_load);
                                    pcma_mt_builder.setValue(resp.code);
                                } 
                                else {
                                    lc_wp_popup_message('error', resp.message);
                                }

                                $wrap.removeClass('pcma_mtb_loading');
                            });	
                            ajax.fail(function(e) {
                                console.error(e);
                                lc_wp_popup_message('error', "<?php esc_attr_e('Error retrieving template data', PCMA_ML) ?>");
                                $wrap.removeClass('pcma_mtb_loading');
                            });	
                        }

                        // be sure contents are empty 
                        else {
                            $('.pcma_mt_builder input[name="pcma_mtb_title"]').val('');
                            $('.pcma_mt_builder input[name="pcma_mail_template_id"]').val('');
                            pcma_mt_builder.setValue('');	
                        }
                    }
                }
            });
        };


        // new template trigger
        $(document).on('click', 'input[name=pcma_add_mail_template]', function() {
            pcma_open_mail_template_lb(false);
        });


        // edit template trigger
        $(document).on('click', '.pcma_mail_templates_list .dashicons-edit', function() {
            var template_id = parseInt( $(this).parents('tr').first().data('template-id'));
            pcma_open_mail_template_lb(template_id);
        });


        // toggle template builder helper visibility
        $(document).on('click', '.pcma_mtb_helper > i', function() {
            var $wrap = $(this).parent();

            $wrap.toggleClass('pcma_mtb_helper_shown');
            ($wrap.hasClass('pcma_mtb_helper_shown')) ? $wrap.find('.pcma_mtb_helper_txt').fadeIn(200) : $wrap.find('.pcma_mtb_helper_txt').fadeOut(200);
        });



        // template code/preview switch
        $(document).on('click', 'input[name="pcma_mtb_code_view"], input[name="pcma_mtb_preview"]', function(e) {
            e.preventDefault();

            var $subj	= $(this),
                $wrap	= $subj.parents('.pcma_mt_builder_wrap'),
                code	= $.trim(pcma_mt_builder.getValue());

            if($('.pcma_mtb_loading').length || $subj.hasClass('pcma_mtb_sel_btn') || !code) {
                return false;	
            }
            $wrap.addClass('pcma_mtb_loading');

            $wrap.find('.pcma_mtb_sel_btn').removeClass('pcma_mtb_sel_btn');
            $subj.addClass('pcma_mtb_sel_btn');


            // let loader to be shown a bit
            setTimeout(function() {

                // preview mode 
                if($subj.attr('name') == 'pcma_mtb_preview') {
                    var unique_id = Math.random().toString(36).substr(2, 9);

                    $wrap.find('.pcma_mt_builder_code_wrap .CodeMirror').hide();
                    $wrap.find('.pcma_mt_builder_preview_wrap').show();

                    // save contents into a transient
                    var data = {
                        action		: 'pcma_store_mail_template_preview',
                        code		: code,
                        preview_id	: unique_id,  
                        nonce		: nonce,
                    };
                    var ajax = $.post(ajaxurl, data, function(response) {
                        if($.trim(response) == 'success') {
                            var $iframe = $wrap.find('.pcma_mt_builder_preview_wrap'),
                                preview_iframe_url = $iframe.data('baseurl') + '?pcma_mtb_token=pcma_mtb&pcma_mtb_key='+ unique_id; 

                            $iframe.attr('src', preview_iframe_url);

                            $iframe.off('load').on('load', function(){
                                $wrap.removeClass('pcma_mtb_loading');
                            });  
                        } 
                        else {
                            console.error(response);
                            lc_wp_popup_message('error', "<?php esc_attr_e('Error processing the preview', PCMA_ML) ?>");
                            $wrap.removeClass('pcma_mtb_loading');
                        }
                    });	
                    ajax.fail(function(e) {
                        console.error(e);
                        lc_wp_popup_message('error', "<?php esc_attr_e('Error processing the preview', PCMA_ML) ?>");
                    });
                }


                // code mode
                else {
                    $wrap.find('.pcma_mt_builder_code_wrap .CodeMirror').show();
                    $wrap.find('.pcma_mt_builder_preview_wrap').hide();	

                    $wrap.removeClass('pcma_mtb_loading');
                }
            }, 600);	
        });



        // template save/update
        $(document).on('click', 'input[name="pcma_mtb_save"]', function(e) {
            e.preventDefault();

            var $wrap 	= $(this).parents('.pcma_mt_builder_wrap'),
                title	= $.trim( $wrap.find('input[name="pcma_mtb_title"]').val()),
                code	= $.trim(pcma_mt_builder.getValue()),
                tpl_id	= parseInt( $wrap.find('input[name="pcma_mail_template_id"]').val());

            if($('.pcma_mtb_loading').length) {
                return false;	
            }
            if(!title || !code) {
                lc_wp_popup_message('error', "<?php esc_attr_e("Please insert template title and contents", PCMA_ML) ?>");
                return false;	
            }
            if(code.indexOf('%CONTENT%') === -1) {
                lc_wp_popup_message('error', "<?php esc_attr_e("Template must contain the %CONTENT% placeholder", PCMA_ML) ?>");
                return false;	
            }
            $wrap.addClass('pcma_mtb_loading');


            // let loader to be shown a bit
            setTimeout(function() {
                var data = {
                    action		: 'pcma_save_mail_template',
                    title		: title,
                    code		: code,  
                    template_id	: tpl_id,
                    nonce		: nonce,
                };
                var ajax = $.post(ajaxurl, data, function(response) {
                    var resp = JSON.parse(response);

                    if(resp.status == 'success') {
                        lc_wp_popup_message('success', "<?php esc_attr_e("Template successfully saved", PCMA_ML) ?>");
                        $wrap.find('input[name="pcma_mail_template_id"]').val(resp.template_id);

                        // new template - refresh dropdowns and templates list
                        pcma_load_mail_templates();	
                    } 
                    else {
                        lc_wp_popup_message('error', resp.message);
                    }

                    $wrap.removeClass('pcma_mtb_loading');
                });	
                ajax.fail(function(e) {
                    console.error(e);
                    lc_wp_popup_message('error', "<?php esc_attr_e("Error saving template", PCMA_ML) ?>");
                    $wrap.removeClass('pcma_mtb_loading');
                });
            }, 600);	
        });



        // template delete
        $(document).on('click', '.pcma_mail_templates_list .dashicons-no-alt', function() {
            var $wrap 		= $(this).parents('tr').first(),
                template_id = parseInt( $wrap.data('template-id'));

            if(!confirm("<?php esc_html_e("Do you really want to delete this template?", PCMA_ML) ?>")) {
                return false;	
            }
            $wrap.fadeTo(200, 0.5);

            // execute
            var data = {
                action		: 'pcma_del_mail_template',
                template_id	: template_id,  
                nonce		: nonce,
            };
            var ajax = $.post(ajaxurl, data, function(response) {
                if($.trim(response) == 'success') {
                    pcma_load_mail_templates();	
                } 
                else {
                    lc_wp_popup_message('error', response);
                    $wrap.fadeTo(200, 1);
                }
            });	
            ajax.fail(function(e) {
                console.error(e);
                lc_wp_popup_message('error', "<?php esc_attr_e('Error deleting template', PCMA_ML) ?>");
                $wrap.fadeTo(200, 1);
            });
        });



        /////////////////////////////////////////////////////////


        
        // store saved mail settings to know whether to require save to test e-mail
        window.get_mail_settings = function() {
            return  $('.pc_pcma_from_name').parents('table').first().find('input, select, textarea').serialize() +'&'+ 
                    $('.pc_pcma_smtp_host').parents('table').first().find('input, select, textarea').serialize();
        };
        
        // wait a bit for form plugins to operate
        let stored_mail_settings;
        setTimeout(function() {
            stored_mail_settings = get_mail_settings();
        }, 500);
        
        
        // disable test e-mail sending if something changed in configuration
        $(document).on(
            'input change keyup', 
            `#mail_config .lcwp_settings_table:nth-child(2) input,
             #mail_config .lcwp_settings_table:nth-child(2) select,

             #mail_config .lcwp_settings_table:nth-child(4) input,
             #mail_config .lcwp_settings_table:nth-child(4) select`, 
            
            function() {
                maybe_disable_test_email_form();     
            }
        );
        
        $(document).on(
            'click',
             `#mail_config .lcwp_settings_table:nth-child(2) .lcs_switch,
             #mail_config .lcwp_settings_table:nth-child(4) .lcs_switch`, 
            
            function() {
                maybe_disable_test_email_form();     
            }
        );
        
        
        const maybe_disable_test_email_form = function() {
            const $target_table = $('.pc_pcma_test_mail').parents('table');
            
            if(get_mail_settings() != stored_mail_settings) {
                if(!$target_table.find('tfoot').length) {
                    $target_table.append(`
                    <tfoot>    
                        <tr>
                            <td colspan="3"><em><?php esc_attr_e("Some settings have been changed. Save them first please.", PCMA_ML) ?></em></td>
                        </tr>
                    </tfoot>`);        
                }
                
                $target_table.find('tbody').hide();
                $target_table.find('tfoot').show();
            }
            else {
                $target_table.find('tbody').show();
                $target_table.find('tfoot').hide();        
            }
        };
        
        

        // test e-mail sending
        $(document).on('click', '#pcma_test_btn', function() {
            var test_mail = $.trim( $('.pc_pcma_test_mail input').val() );
            var emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;

            if(test_mail != '' && emailReg.test(test_mail)) {
                if(confirm('<?php esc_attr_e("A test e-mail will be sent to", PCMA_ML) ?> '+test_mail+', <?php esc_attr_e("continue?", PCMA_ML) ?>')) {
                    $('#pcma_test_result').html('<div class="pc_spinner pc_spinner_inline"></div>');

                    var data = {
                        action		: 'pcma_test_mail_settings',
                        pcma_mail	: test_mail,
                        template_id	: $('select[name=pcma_test_mail_template]').val(),
                        nonce		: nonce,
                    };
                    let got_response = false;
                    
                    let operation = $.post(ajaxurl, data, function(response) {
                        $('#pcma_test_result').html(response);
                    })
                    .fail(function(e) {
                        if(e.status) {
                            console.error(e);
                            lc_wp_popup_message('error', "<?php esc_html_e('Error performing the action', PCMA_ML) ?>");
                        }

                        $('#pcma_test_result').empty();
                    })
                    .always(function() {
                        got_response = true;    
                    });	
                    
                    setTimeout(function() {
                        if(!got_response) {
                            operation.abort(); 
                            $('#pcma_test_result').html("<?php esc_html_e('Operation timed out', PCMA_ML) ?>");
                        }
                    }, 10000);
                }
            }
            else {
                $('#pcma_test_result').html('<?php esc_attr_e("Insert a valid e-mail", PCMA_ML) ?>');
            }

        });


        
        
        /////////////////////////////////////////////////////////


        
        
        // tinymce preview + demo sending and emoji 
        <?php
    
        /* PCMA-FILTER - allow extra WP editors to have emoji and preview in PCMA settings page. 
         * Must pass an array or arrays containing right keys
            
            editor_id       
            title_f_name    
            template_f_name  
         */
        $extra_pne_editors = (array)apply_filters('pcma_extra_pne_editors', array());         
        ?>
        const pne_subjs_keys = ['mv', 'nnu', 'dun', 'nau', 'wm', 'gm', 'niu', 'psw_mail', 'uppu_mail'],
              extra_pne_editors = JSON.parse(`<?php echo json_encode($extra_pne_editors) ?>`);
              
        let preview_n_emoji_subjs = [];
              
        $.each(pne_subjs_keys, function(i, key) {
            preview_n_emoji_subjs.push({
                editor_id       : 'pcma_'+ key +'_txt',
                title_f_name    : 'pcma_'+ key +'_subj',
                template_f_name : 'pcma_'+ key +'_template',  
            });   
        });
        
        if(extra_pne_editors && typeof(extra_pne_editors) == 'object') {
            $.each(extra_pne_editors, function(i, v) {
                preview_n_emoji_subjs.push(v);        
            });    
        }
        
        $(document).ready(function() {
            $.each(preview_n_emoji_subjs, function(i, v) {
                window.pcma_setup_tinymce_emoji_n_preview(v.editor_id, v.title_f_name, v.template_f_name);
            });
        });
        
        
        

        /////////////////////////////////////////////////////////




        // manual users verification
        $(document).on('click', '.pcma_mv_manual_btn', function() {
            let user_cat = $(this).attr('rel');
            let $mv_result = $(this).parents('tr').find('.pcma_mv_manual_result');

            if(user_cat == 'all') {
                var mess = '<?php esc_attr_e("All active users with an e-mail will be verified. Continue?", PCMA_ML) ?>';
            }
            else {
                var mess = '<?php esc_attr_e("Active users with an e-mail in this category will be verified. Continue?", PCMA_ML) ?>';
            }

            if(!mv_is_acting && confirm(mess)) {
                mv_is_acting = true;
                $mv_result.html('<div class="pc_spinner pc_spinner_inline"></div>');

                var data = {
                    action		: 'pcma_mv_group_manual',
                    pcma_cat	: user_cat,
                    nonce		: nonce
                };
                $.post(ajaxurl, data, function(response) {
                    var resp = $.trim(response);

                    if(resp == 'success') {
                        $mv_result.html('<?php esc_attr_e("Users verified successfully", PCMA_ML) ?>');
                    }
                    else {
                        $mv_result.html(resp);
                    }
                })
                .fail(function(e) {
                    if(e.status) {
                        console.error(e);
                        lc_wp_popup_message('error', "<?php esc_html_e('Error performing the action', PCMA_ML) ?>");

                        $mv_result.empty();
                    }
                })
                .always(function() {
                    mv_is_acting = false;      
                });
            }
        });


        // send verification e-mails
        $(document).on('click', '.pcma_send_vmail_btn', function() {
            var user_cat = $(this).attr('rel');
            let $mv_result = $(this).parents('tr').find('.pcma_mv_manual_result');

            if(user_cat == 'all') {
                var mess = '<?php esc_attr_e("E-mail will be sent to any active user with an e-mail. Continue?", PCMA_ML) ?>';
            }
            else {
                var mess = '<?php esc_attr_e("E-mail will be sent to active users in this category. Continue?", PCMA_ML) ?>';
            }

            if(!mv_is_acting && confirm(mess)) {
                mv_is_acting = true;
                $mv_result.html('<div class="pc_spinner pc_spinner_inline"></div>');

                var data = {
                    action		: 'pcma_group_manual_send_vmail',
                    pcma_cat	: user_cat,
                    nonce		: nonce,
                };
                $.post(ajaxurl, data, function(response) {
                    var resp = $.trim(response);

                    if(resp == 'success') {
                        $mv_result.html('<?php esc_attr_e("E-mails sent successfully", PCMA_ML) ?>');
                    }
                    else {
                        $mv_result.html(resp);
                    }
                })
                .fail(function(e) {
                    if(e.status) {
                        console.error(e);
                        lc_wp_popup_message('error', "<?php esc_html_e('Error performing the action', PCMA_ML) ?>");

                        $mv_result.empty();
                    }
                })
                .always(function() {
                    mv_is_acting = false;      
                });
            }
        });


        // mailchimp - sync manually
        $(document).on('click', '#pcma_mc_sync', function() {
            if(mailc_is_acting) {
                return true;
            }


            mailc_is_acting = true;
            $('#pcma_mc_sync_result').html('<div class="pc_spinner pc_spinner_inline"></div>');

            var data = {
                action	: 'pcma_mc_ajax_sync',
                nonce	: nonce
            };
            $.post(ajaxurl, data, function(response) {
                try {
                    var resp = $.parseJSON($.trim(response));

                    if(resp.status == 1) {
                        $('#pcma_mc_sync_required').remove();	
                    }

                    $('#pcma_mc_sync_result').html('<strong>'+ resp.mess +'</strong>');
                }
                catch(e) {
                    console.error(e);

                    $('#pcma_mc_sync_result').html('<strong><?php esc_html_e('Error performing the action', PCMA_ML) ?></strong>');
                    mailc_is_acting = false;
                }
            })
            .fail(function(e) {
                if(e.status) {
                    console.error(e);
                    $('#pcma_mc_sync_result').html('<strong><?php esc_html_e('Error performing the action', PCMA_ML) ?></strong>');
                }
            })
            .always(function() {
                mailc_is_acting = false;
            });
        });



        //////////////////////////////////////////////////



        // options search
        let lcwp_sf_search_tout = false;
        $(document).on('keyup', '.lcwp_sf_search_wrap input', function(e) {
            const val = $(this).val().trim();

            if(lcwp_sf_search_tout) {
                clearTimeout(lcwp_sf_search_tout);    
            }

            lcwp_sf_search_tout = setTimeout(function() {
                // reset
                $('.lcsw_sf_search_no_res').remove();
                $('.lcsw_sf_search_excluded').removeClass('lcsw_sf_search_excluded');

                // elaborate
                if(val.length < 3) {
                    $('.lcwp_sf_search_wrap').removeClass('lcwp_sf_searching');
                }
                else {
                    $('.lcwp_sf_search_wrap').addClass('lcwp_sf_searching');
                    $('.lcwp_sf_spacer').parent().addClass('lcsw_sf_search_excluded');  

                    // cycle through sections
                    $('.lcwp_settings_table').each(function() {
                        let hide_table = true;

                        $(this).find('.lcwp_sf_label label').each(function() {
                            const $tr = $(this).parents('tr').first();

                            let matching_string = $(this).text().trim().toLowerCase();
                            if($tr.find('.lcwp_sf_note').length) {
                                matching_string += ' '+ $tr.find('.lcwp_sf_note').text();
                            }

                            if(matching_string.indexOf( val.toLowerCase() ) === -1) {
                                $tr.addClass('lcsw_sf_search_excluded');    
                            }
                            else {
                                hide_table = false;
                                $tr.removeClass('lcsw_sf_search_excluded');    
                            }
                        });

                        if(hide_table) {
                            $(this).addClass('lcsw_sf_search_excluded');
                            $(this).prev('h3').addClass('lcsw_sf_search_excluded');
                        }
                    });

                    // leave only tabs with matching options
                    $('.lcwp_settings_block').each(function() {
                        if(!$(this).find('> *:not(.lcsw_sf_search_excluded):not(script):not(style)').length) {
                            $('a.nav-tab[href="#'+ $(this).attr('id') +'"]').addClass('lcsw_sf_search_excluded');    
                        }
                    });

                    // select first tab with matching options
                    if($('a.nav-tab').not('.lcsw_sf_search_excluded').length) {
                        $('a.nav-tab').not('.lcsw_sf_search_excluded').first().click();
                    } else {
                        $('.nav-tab-wrapper').append('<span class="lcsw_sf_search_no_res"><?php esc_html_e('No matching options', PCMA_ML) ?> ..</span>');    
                    }
                }
            }, 500);
        });
        $('.lcwp_sf_search_wrap input').val(''); // avoid browser cache


        // reset search
        $(document).on('click', '.lcwp_sf_search_wrap i', function() {
            $('.lcwp_sf_search_wrap input').val('').trigger('keyup');        
        });



        //////////////////////////////////////////////////



        // tabify
        $('.lcwp_settings_tabs').each(function() {
            var sel = '';
            var hash = window.location.hash;

            var $form = $(".lcwp_settings_form");
            var form_act = $form.attr('action');

            // track URL on opening
            if(hash && $(this).find('.nav-tab[href="'+ hash +'"]').length) {
                $(this).find('.nav-tab').removeClass('nav-tab-active');
                $(this).find('.nav-tab[href="'+ hash +'"]').addClass('nav-tab-active');	

                $form.attr('action', form_act + hash);
            }

            // if no active - set first as active
            if(!$(this).find('.nav-tab-active').length) {
                $(this).find('.nav-tab').first().addClass('nav-tab-active');	
            }

            // hide unselected
            $(this).find('.nav-tab').each(function() {
                var id = $(this).attr('href');

                if($(this).hasClass('nav-tab-active')) {
                    sel = id
                }
                else {
                    $(id).hide();
                }
            });
            
            
            // layout fix if there are more than 10 settings tabs
            if($(this).find('.nav-tab').length > 10) {
                $(this).addClass('lcwp_settings_crowded_tabs');        
            }
            

            // scroll to top by default
            $("html, body").animate({scrollTop: 0}, 0);

            // track clicks
            if(sel) {
                $(this).find('.nav-tab').on('click', function(e) {
                    e.preventDefault();
                    if($(this).hasClass('nav-tab-active')) {
                        return false;
                    }

                    var sel_id = $(this).attr('href');
                    window.location.hash = sel_id.replace('#', '');

                    $form.attr('action', form_act + sel_id);

                    // show selected and hide others
                    $(this).parents('.lcwp_settings_tabs').find('.nav-tab').each(function() {
                        var id = $(this).attr('href');

                        if(sel_id == id) {
                            $(this).addClass('nav-tab-active');
                            $(id).show();		
                        }
                        else {
                            $(this).removeClass('nav-tab-active');
                            $(id).hide();	
                        }
                    });
                });
            }
        });


        // sticky tabs on scroll
        let lcwp_sf_sticky_tabs_tout = false;

        const $tabs = $('.lcwp_settings_tabs'),
              tabs_top_pos = Math.round($tabs.offset().top);

        const lcwp_sf_sticky_tabs = function() {
            if(lcwp_sf_sticky_tabs_tout) {
                clearTimeout(lcwp_sf_sticky_tabs_tout);    
            }

            lcwp_sf_sticky_tabs_tout = setTimeout(function() {
                if(document.documentElement.scrollTop > (tabs_top_pos + $tabs.outerHeight(true) + 20)) {
                    $('.lcwp_settings_form').css('margin-top', $tabs.outerHeight(true));
                    $tabs.addClass('lcwp_st_sticky');
                }
                else {
                    $('.lcwp_settings_form').css('margin-top', 0);
                    $tabs.removeClass('lcwp_st_sticky'); 
                }
            }, 10);
        };
        $(window).scroll(function() {
            lcwp_sf_sticky_tabs();
        });
        $(window).resize(function() {
            lcwp_sf_sticky_tabs();    
        });
        lcwp_sf_sticky_tabs(); // on page's show


        // lc switch
        var pcma_live_checks = function() { 
            lc_switch('.lcwp_sf_check', {
                on_txt      : "<?php echo strtoupper(esc_attr__('yes')) ?>",
                off_txt     : "<?php echo strtoupper(esc_attr__('no')) ?>",   
            });
        }
        pcma_live_checks();


        // lc_select
        var pcma_lc_select = function() { 
            new lc_select('.lcwp_sf_select', {
                wrap_width : '90%',
                addit_classes : ['lcslt-lcwp'],
            });
        }
        pcma_lc_select();


        // sliders
        new lc_range_n_num('.lcwp_sf_slider_input', {
            unit_width: 17    
        });
        
        
        // auto-height textarea
        window.lcwp_sf_textAreaAdjust = function(o) {
            o.style.height = "1px";
            o.style.height = (4 + o.scrollHeight)+"px";
        };
        $('.lcwp_sf_textarea').each(function() {
            lcwp_sf_textAreaAdjust(this);    
        });



        //////////////////////////////////////////////////


        // fixed submit position
        const lcwp_sf_fixed_submit = function(btn_selector) {
            const $subj = $(btn_selector);
            if(!$subj.length) {
                return false;
            }

            let clone = $subj.clone().wrap("<div />").parent().html();

            setInterval(function() {

                // if page has scrollers or scroll is far from bottom
                if(($(document).height() > $(window).height()) && ($(document).height() - $(window).height() - $(window).scrollTop()) > 130) {
                    if(!$('.lcwp_settings_fixed_submit').length) {	
                        $subj.after('<div class="lcwp_settings_fixed_submit">'+ clone +'</div>');
                    }
                }
                else {
                    if($('.lcwp_settings_fixed_submit').length) {	
                        $('.lcwp_settings_fixed_submit').remove();
                    }
                }
            }, 50);
        };
        lcwp_sf_fixed_submit('.lcwp_settings_submit');


        //////////////////////////////////////////////////


        // popup message for better visibility
        if($('.lcwp_settings_result').length) {
            const $subj = $('.lcwp_settings_result');

            // if success - simply hide main one
            if($subj.hasClass('updated')) {
                $subj.remove();	
                lc_wp_popup_message('success', '<p>'+ $subj.find('p').html() +'</p>');
            }

            // show errors but keep them visible on top
            else {
                const pre_heading = (window.location.href.indexOf('lcwp_sf_import') !== -1) ? 
                    `<?php esc_html_e('One or more errors occurred during the import', $ml_key) ?>` : 
                    `<?php esc_html_e('One or more errors occurred', $ml_key) ?>`;
                      
                const error_contents = ($subj.find('ul').length) ? $subj.find('ul')[0].outerHTML : $subj.find('p')[0].innerHTML;
                lc_wp_popup_message('error', "<h4><?php esc_html_e('One or more errors occurred', $ml_key) ?>:</h4>" + error_contents);

                $("html, body").animate({scrollTop: 0}, 0);		


                // try adding links bringing directly to option lines
                $subj.find('ul li').each(function() {
                    const $err_li = $(this);

                    let subjs = $err_li.text().split(' - ')[0];
                    subjs = subjs.split(',');

                    $.each(subjs, function(i, label) {
                        label = label.toString().trim();

                        $('.lcwp_sf_label label').each(function() {
                            if( $(this).text().trim().toLowerCase() == label.toLowerCase() ) {
                                $err_li.html( 
                                    $err_li.html().replace(label, '<a href="#'+ $(this).parents('tr').first().attr('class') +'" title="<?php esc_attr_e('go to option', $ml_key) ?>" class="lcwp_sf_err_link">'+ label +'</a>')
                                );

                                return false;
                            }
                        });
                    });
                });
            }
            
            // remove eventual url parameters
            history.replaceState(null, null, settings_baseurl);
        }	


        // error-to-option direct search
        $(document).on('click', '.lcwp_sf_err_link', function(e) {
            e.preventDefault();
            const tr_selector = $(this).attr('href').replace('#', ''),
                  label = $('.'+tr_selector +' .lcwp_sf_label').text();

            $('.lcwp_sf_search_wrap input').val(label).trigger('keyup');
        });
    });
    
})(jQuery);    
</script>


<?php
// PC-ACTION - allow extra code printing in settings (for javascript/css)
do_action('pcma_settings_extra_code');
?>
